<?php
namespace App\Controllers;

use App\Models\Usuario;

class AdminController
{
    public function dashboard()
    {
        session_start();
        if (!isset($_SESSION['usuario_id']) || $_SESSION['usuario_tipo'] !== 'diretor') {
            header('Location: /auth/login');
            exit;
        }

        $usuarioModel = new Usuario();

        // Conta usuários por tipo
        $pdo = $usuarioModel->__construct(); // Garante pdo carregado
        $pdo = (new Usuario())->pdo;

        $alunos = $pdo->query("SELECT COUNT(*) as total FROM usuarios WHERE tipo = 'aluno'")->fetch()['total'] ?? 0;
        $instrutores = $pdo->query("SELECT COUNT(*) as total FROM usuarios WHERE tipo = 'instrutor'")->fetch()['total'] ?? 0;
        $aulas = $pdo->query("SELECT COUNT(*) as total FROM aulas")->fetch()['total'] ?? 0;

        echo "<h2>Painel do Diretor</h2>";
        echo "<p><strong>Alunos cadastrados:</strong> {$alunos}</p>";
        echo "<p><strong>Instrutores cadastrados:</strong> {$instrutores}</p>";
        echo "<p><strong>Agendamentos de aulas:</strong> {$aulas}</p>";
        echo "<hr>";
        echo "<a href='/admin/instrutores'>Gerenciar Instrutores</a> | ";
        echo "<a href='/admin/alunos'>Gerenciar Alunos</a> | ";
        echo "<a href='/auth/logout'>Sair</a>";
    }

    // Listar instrutores
    public function instrutores()
    {
        session_start();
        if (!isset($_SESSION['usuario_id']) || $_SESSION['usuario_tipo'] !== 'diretor') {
            header('Location: /auth/login');
            exit;
        }

        $usuarioModel = new Usuario();
        $pdo = $usuarioModel->__construct(); // Garante pdo carregado
        $pdo = (new Usuario())->pdo;

        $stmt = $pdo->query("SELECT * FROM usuarios WHERE tipo = 'instrutor'");
        $instrutores = $stmt->fetchAll();

        echo "<h2>Instrutores</h2>";
        echo "<a href='/admin/novoInstrutor'>Cadastrar Novo Instrutor</a><br><br>";
        if ($instrutores) {
            echo "<table border='1' cellpadding='6'><tr>
                    <th>Nome</th><th>CPF</th><th>Telefone</th><th>Email</th><th>Ações</th>
                  </tr>";
            foreach ($instrutores as $inst) {
                echo "<tr>
                        <td>{$inst['nome']}</td>
                        <td>{$inst['cpf']}</td>
                        <td>{$inst['telefone']}</td>
                        <td>{$inst['email']}</td>
                        <td>
                            <a href='/admin/editarInstrutor/{$inst['id']}'>Editar</a> | 
                            <a href='/admin/excluirInstrutor/{$inst['id']}'>Excluir</a>
                        </td>
                      </tr>";
            }
            echo "</table>";
        } else {
            echo "<p>Nenhum instrutor cadastrado.</p>";
        }
        echo "<br><a href='/admin/dashboard'>Voltar</a>";
    }

    // Listar alunos
    public function alunos()
    {
        session_start();
        if (!isset($_SESSION['usuario_id']) || $_SESSION['usuario_tipo'] !== 'diretor') {
            header('Location: /auth/login');
            exit;
        }

        $usuarioModel = new Usuario();
        $pdo = $usuarioModel->__construct(); // Garante pdo carregado
        $pdo = (new Usuario())->pdo;

        $stmt = $pdo->query("SELECT * FROM usuarios WHERE tipo = 'aluno'");
        $alunos = $stmt->fetchAll();

        echo "<h2>Alunos</h2>";
        echo "<a href='/admin/novoAluno'>Cadastrar Novo Aluno</a><br><br>";
        if ($alunos) {
            echo "<table border='1' cellpadding='6'><tr>
                    <th>Nome</th><th>CPF</th><th>Telefone</th><th>Email</th><th>Ações</th>
                  </tr>";
            foreach ($alunos as $aluno) {
                echo "<tr>
                        <td>{$aluno['nome']}</td>
                        <td>{$aluno['cpf']}</td>
                        <td>{$aluno['telefone']}</td>
                        <td>{$aluno['email']}</td>
                        <td>
                            <a href='/admin/editarAluno/{$aluno['id']}'>Editar</a> | 
                            <a href='/admin/excluirAluno/{$aluno['id']}'>Excluir</a>
                        </td>
                      </tr>";
            }
            echo "</table>";
        } else {
            echo "<p>Nenhum aluno cadastrado.</p>";
        }
        echo "<br><a href='/admin/dashboard'>Voltar</a>";
    }

    // Formulário de novo instrutor
    public function novoInstrutor()
    {
        session_start();
        if (!isset($_SESSION['usuario_id']) || $_SESSION['usuario_tipo'] !== 'diretor') {
            header('Location: /auth/login');
            exit;
        }
        echo "<h2>Novo Instrutor</h2>
            <form method='post' action='/admin/salvarInstrutor'>
                <input name='nome' placeholder='Nome' required><br>
                <input name='cpf' placeholder='CPF' required><br>
                <input name='telefone' placeholder='Telefone' required><br>
                <input name='email' placeholder='Email' type='email' required><br>
                <input name='senha' placeholder='Senha' type='password' required><br>
                <button type='submit'>Salvar</button>
            </form>
            <a href='/admin/instrutores'>Voltar</a>";
    }

    // Salvar novo instrutor
    public function salvarInstrutor()
    {
        session_start();
        if (!isset($_SESSION['usuario_id']) || $_SESSION['usuario_tipo'] !== 'diretor') {
            header('Location: /auth/login');
            exit;
        }
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $usuarioModel = new Usuario();
            $dados = [
                'nome' => $_POST['nome'],
                'cpf' => $_POST['cpf'],
                'telefone' => $_POST['telefone'],
                'email' => $_POST['email'],
                'senha' => password_hash($_POST['senha'], PASSWORD_DEFAULT),
                'tipo' => 'instrutor'
            ];
            $usuarioModel->create($dados);
            header('Location: /admin/instrutores');
            exit;
        }
    }

    // Formulário de novo aluno
    public function novoAluno()
    {
        session_start();
        if (!isset($_SESSION['usuario_id']) || $_SESSION['usuario_tipo'] !== 'diretor') {
            header('Location: /auth/login');
            exit;
        }
        echo "<h2>Novo Aluno</h2>
            <form method='post' action='/admin/salvarAluno'>
                <input name='nome' placeholder='Nome' required><br>
                <input name='cpf' placeholder='CPF' required><br>
                <input name='telefone' placeholder='Telefone' required><br>
                <input name='email' placeholder='Email' type='email' required><br>
                <input name='senha' placeholder='Senha' type='password' required><br>
                <button type='submit'>Salvar</button>
            </form>
            <a href='/admin/alunos'>Voltar</a>";
    }

    // Salvar novo aluno
    public function salvarAluno()
    {
        session_start();
        if (!isset($_SESSION['usuario_id']) || $_SESSION['usuario_tipo'] !== 'diretor') {
            header('Location: /auth/login');
            exit;
        }
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $usuarioModel = new Usuario();
            $dados = [
                'nome' => $_POST['nome'],
                'cpf' => $_POST['cpf'],
                'telefone' => $_POST['telefone'],
                'email' => $_POST['email'],
                'senha' => password_hash($_POST['senha'], PASSWORD_DEFAULT),
                'tipo' => 'aluno'
            ];
            $usuarioModel->create($dados);
            header('Location: /admin/alunos');
            exit;
        }
    }

    // Novo método para editar instrutor (formulário)
    public function editarInstrutor($id)
    {
        session_start();
        if (!isset($_SESSION['usuario_id']) || $_SESSION['usuario_tipo'] !== 'diretor') {
            header('Location: /auth/login');
            exit;
        }

        $usuarioModel = new Usuario();
        $instrutor = $usuarioModel->findById($id);

        if (!$instrutor || $instrutor['tipo'] !== 'instrutor') {
            echo "<p>Instrutor não encontrado.</p><a href='/admin/instrutores'>Voltar</a>";
            return;
        }

        echo "<h2>Editar Instrutor</h2>
            <form method='post' action='/admin/salvarEdicaoInstrutor/{$id}'>
                <input name='nome' value='{$instrutor['nome']}' placeholder='Nome' required><br>
                <input name='cpf' value='{$instrutor['cpf']}' placeholder='CPF' required><br>
                <input name='telefone' value='{$instrutor['telefone']}' placeholder='Telefone' required><br>
                <input name='email' value='{$instrutor['email']}' placeholder='Email' type='email' required><br>
                <input name='senha' placeholder='Nova Senha (preencha apenas se for alterar)' type='password'><br>
                <button type='submit'>Salvar</button>
            </form>
            <a href='/admin/instrutores'>Voltar</a>";
    }

    // Salvar edição do instrutor
    public function salvarEdicaoInstrutor($id)
    {
        session_start();
        if (!isset($_SESSION['usuario_id']) || $_SESSION['usuario_tipo'] !== 'diretor') {
            header('Location: /auth/login');
            exit;
        }
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $usuarioModel = new Usuario();
            $dados = [
                'nome' => $_POST['nome'],
                'cpf' => $_POST['cpf'],
                'telefone' => $_POST['telefone'],
                'email' => $_POST['email'],
            ];
            if (!empty($_POST['senha'])) {
                $dados['senha'] = password_hash($_POST['senha'], PASSWORD_DEFAULT);
            }
            // Atualiza apenas os campos editados
            $set = "nome = :nome, cpf = :cpf, telefone = :telefone, email = :email";
            if (isset($dados['senha'])) {
                $set .= ", senha = :senha";
            }
            $sql = "UPDATE usuarios SET {$set} WHERE id = :id AND tipo = 'instrutor'";
            $stmt = (new Usuario())->pdo->prepare($sql);
            $dados['id'] = $id;
            $stmt->execute($dados);
            header('Location: /admin/instrutores');
            exit;
        }
    }

    // Excluir instrutor
    public function excluirInstrutor($id)
    {
        session_start();
        if (!isset($_SESSION['usuario_id']) || $_SESSION['usuario_tipo'] !== 'diretor') {
            header('Location: /auth/login');
            exit;
        }
        $stmt = (new Usuario())->pdo->prepare("DELETE FROM usuarios WHERE id = :id AND tipo = 'instrutor'");
        $stmt->execute(['id' => $id]);
        header('Location: /admin/instrutores');
        exit;
    }

    // Editar aluno (formulário)
    public function editarAluno($id)
    {
        session_start();
        if (!isset($_SESSION['usuario_id']) || $_SESSION['usuario_tipo'] !== 'diretor') {
            header('Location: /auth/login');
            exit;
        }

        $usuarioModel = new Usuario();
        $aluno = $usuarioModel->findById($id);

        if (!$aluno || $aluno['tipo'] !== 'aluno') {
            echo "<p>Aluno não encontrado.</p><a href='/admin/alunos'>Voltar</a>";
            return;
        }

        echo "<h2>Editar Aluno</h2>
            <form method='post' action='/admin/salvarEdicaoAluno/{$id}'>
                <input name='nome' value='{$aluno['nome']}' placeholder='Nome' required><br>
                <input name='cpf' value='{$aluno['cpf']}' placeholder='CPF' required><br>
                <input name='telefone' value='{$aluno['telefone']}' placeholder='Telefone' required><br>
                <input name='email' value='{$aluno['email']}' placeholder='Email' type='email' required><br>
                <input name='senha' placeholder='Nova Senha (preencha apenas se for alterar)' type='password'><br>
                <button type='submit'>Salvar</button>
            </form>
            <a href='/admin/alunos'>Voltar</a>";
    }

    // Salvar edição do aluno
    public function salvarEdicaoAluno($id)
    {
        session_start();
        if (!isset($_SESSION['usuario_id']) || $_SESSION['usuario_tipo'] !== 'diretor') {
            header('Location: /auth/login');
            exit;
        }
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $usuarioModel = new Usuario();
            $dados = [
                'nome' => $_POST['nome'],
                'cpf' => $_POST['cpf'],
                'telefone' => $_POST['telefone'],
                'email' => $_POST['email'],
            ];
            if (!empty($_POST['senha'])) {
                $dados['senha'] = password_hash($_POST['senha'], PASSWORD_DEFAULT);
            }
            $set = "nome = :nome, cpf = :cpf, telefone = :telefone, email = :email";
            if (isset($dados['senha'])) {
                $set .= ", senha = :senha";
            }
            $sql = "UPDATE usuarios SET {$set} WHERE id = :id AND tipo = 'aluno'";
            $stmt = (new Usuario())->pdo->prepare($sql);
            $dados['id'] = $id;
            $stmt->execute($dados);
            header('Location: /admin/alunos');
            exit;
        }
    }

    // Novo método para editar aluno (formulário)
    public function editarAluno($id)
    {
        session_start();
        if (!isset($_SESSION['usuario_id']) || $_SESSION['usuario_tipo'] !== 'diretor') {
            header('Location: /auth/login');
            exit;
        }

        $usuarioModel = new Usuario();
        $aluno = $usuarioModel->findById($id);

        if (!$aluno || $aluno['tipo'] !== 'aluno') {
            echo "<p>Aluno não encontrado.</p><a href='/admin/alunos'>Voltar</a>";
            return;
        }

        echo "<h2>Editar Aluno</h2>
            <form method='post' action='/admin/salvarEdicaoAluno/{$id}'>
                <input name='nome' value='{$aluno['nome']}' placeholder='Nome' required><br>
                <input name='cpf' value='{$aluno['cpf']}' placeholder='CPF' required><br>
                <input name='telefone' value='{$aluno['telefone']}' placeholder='Telefone' required><br>
                <input name='email' value='{$aluno['email']}' placeholder='Email' type='email' required><br>
                <input name='senha' placeholder='Nova Senha (preencha apenas se for alterar)' type='password'><br>
                <button type='submit'>Salvar</button>
            </form>
            <a href='/admin/alunos'>Voltar</a>";
    }

    // Salvar edição do aluno
    public function salvarEdicaoAluno($id)
    {
        session_start();
        if (!isset($_SESSION['usuario_id']) || $_SESSION['usuario_tipo'] !== 'diretor') {
            header('Location: /auth/login');
            exit;
        }
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $usuarioModel = new Usuario();
            $dados = [
                'nome' => $_POST['nome'],
                'cpf' => $_POST['cpf'],
                'telefone' => $_POST['telefone'],
                'email' => $_POST['email'],
            ];
            if (!empty($_POST['senha'])) {
                $dados['senha'] = password_hash($_POST['senha'], PASSWORD_DEFAULT);
            }
            $set = "nome = :nome, cpf = :cpf, telefone = :telefone, email = :email";
            if (isset($dados['senha'])) {
                $set .= ", senha = :senha";
            }
            $sql = "UPDATE usuarios SET {$set} WHERE id = :id AND tipo = 'aluno'";
            $stmt = (new Usuario())->pdo->prepare($sql);
            $dados['id'] = $id;
            $stmt->execute($dados);
            header('Location: /admin/alunos');
            exit;
        }
    }

    // Excluir aluno
    public function excluirAluno($id)
    {
        session_start();
        if (!isset($_SESSION['usuario_id']) || $_SESSION['usuario_tipo'] !== 'diretor') {
            header('Location: /