<?php
namespace App\Controllers;

use App\Models\Usuario;

class AuthController
{
    public function login()
    {
        // Exibe o formulário de login
        echo '<h2>Login</h2>
            <form method="post" action="/auth/doLogin">
                <input type="email" name="email" placeholder="E-mail" required><br>
                <input type="password" name="senha" placeholder="Senha" required><br>
                <button type="submit">Entrar</button>
            </form>';
    }

    public function doLogin()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $email = $_POST['email'] ?? '';
            $senha = $_POST['senha'] ?? '';

            $usuarioModel = new Usuario();
            $usuario = $usuarioModel->findByEmail($email);

            if ($usuario && password_verify($senha, $usuario['senha'])) {
                session_start();
                $_SESSION['usuario_id'] = $usuario['id'];
                $_SESSION['usuario_tipo'] = $usuario['tipo'];
                $_SESSION['usuario_nome'] = $usuario['nome'];

                // Redireciona para dashboard baseado no tipo
                if ($usuario['tipo'] === 'diretor') {
                    header('Location: /admin/dashboard');
                } elseif ($usuario['tipo'] === 'instrutor') {
                    header('Location: /instrutor/dashboard');
                } else {
                    header('Location: /aluno/dashboard');
                }
                exit;
            } else {
                echo '<p style="color:red">E-mail ou senha inválidos.</p>';
                $this->login();
            }
        } else {
            header('Location: /auth/login');
            exit;
        }
    }

    public function logout()
    {
        session_start();
        session_destroy();
        header('Location: /auth/login');
        exit;
    }
}