<?php
namespace App\Controllers;

use App\Models\ConfigWhatsapp;
use GuzzleHttp\Client;

class WhatsappController
{
    public function config()
    {
        session_start();
        if (!isset($_SESSION['usuario_id']) || $_SESSION['usuario_tipo'] !== 'diretor') {
            header('Location: /auth/login');
            exit;
        }

        $configModel = new ConfigWhatsapp();
        $config = $configModel->getConfig();

        echo "<h2>Integração WhatsApp Evolution API</h2>";

        if ($config && $config['status'] === 'conectado') {
            echo "<p>Status: <span style='color:green;'>Conectado</span></p>";
            echo "<p>Instância: <b>{$config['instancia']}</b></p>";
            echo "<a href='/admin/dashboard'>Voltar ao Painel</a>";
        } else {
            echo "<p>Status: <span style='color:orange;'>Não conectado</span></p>";
            echo "<form method='post' action='/whatsapp/gerarInstancia'>
                <button type='submit'>Gerar Instância/QR Code</button>
                </form>";
            if ($config && $config['qrcode']) {
                echo "<p>Escaneie o QR Code abaixo no WhatsApp:</p>";
                echo "<img src='data:image/png;base64,{$config['qrcode']}' alt='QR Code' width='300'>";
            }
            echo "<br><a href='/admin/dashboard'>Voltar ao Painel</a>";
        }
    }

    public function gerarInstancia()
    {
        session_start();
        if (!isset($_SESSION['usuario_id']) || $_SESSION['usuario_tipo'] !== 'diretor') {
            header('Location: /auth/login');
            exit;
        }

        $evoUrl = $_ENV['EVOLUTION_API_URL'];
        $apiKey = $_ENV['EVOLUTION_API_KEY'];

        $client = new Client(['base_uri' => $evoUrl]);
        try {
            // Exemplo de endpoint para gerar instância, ajuste conforme doc oficial
            $response = $client->post('/instance', [
                'headers' => ['Authorization' => $apiKey]
            ]);
            $data = json_decode($response->getBody(), true);

            if (isset($data['instance']) && isset($data['qrcode'])) {
                $model = new ConfigWhatsapp();
                $model->create($data['instance'], $data['qrcode'], 'pendente');
                header('Location: /whatsapp/config');
                exit;
            } else {
                echo "<p>Falha ao gerar instância/QR Code.</p>";
            }
        } catch (\Exception $e) {
            echo "<p>Erro na integração: {$e->getMessage()}</p>";
        }
        echo "<a href='/admin/dashboard'>Voltar ao Painel</a>";
    }
}