<?php
namespace App\Models;

use PDO;

class Aula
{
    public $pdo;

    public function __construct()
    {
        require_once(dirname(__DIR__, 2) . '/config/database.php');
        $this->pdo = getPDO();
    }

    public function create($aluno_id, $instrutor_id, $data, $hora_inicio, $hora_fim)
    {
        $stmt = $this->pdo->prepare('
            INSERT INTO aulas (aluno_id, instrutor_id, data, hora_inicio, hora_fim) 
            VALUES (:aluno_id, :instrutor_id, :data, :hora_inicio, :hora_fim)
        ');
        return $stmt->execute([
            'aluno_id' => $aluno_id,
            'instrutor_id' => $instrutor_id,
            'data' => $data,
            'hora_inicio' => $hora_inicio,
            'hora_fim' => $hora_fim
        ]);
    }

    public function findById($id)
    {
        $stmt = $this->pdo->prepare('SELECT * FROM aulas WHERE id = :id');
        $stmt->execute(['id' => $id]);
        return $stmt->fetch();
    }

    public function getByInstrutor($instrutor_id)
    {
        $stmt = $this->pdo->prepare('
            SELECT a.*, u.nome as aluno_nome 
            FROM aulas a 
            JOIN usuarios u ON a.aluno_id = u.id 
            WHERE a.instrutor_id = :instrutor_id 
            ORDER BY a.data DESC, a.hora_inicio DESC
        ');
        $stmt->execute(['instrutor_id' => $instrutor_id]);
        return $stmt->fetchAll();
    }

    public function getByAluno($aluno_id)
    {
        $stmt = $this->pdo->prepare('
            SELECT a.*, u.nome as instrutor_nome 
            FROM aulas a 
            JOIN usuarios u ON a.instrutor_id = u.id 
            WHERE a.aluno_id = :aluno_id 
            ORDER BY a.data DESC, a.hora_inicio DESC
        ');
        $stmt->execute(['aluno_id' => $aluno_id]);
        return $stmt->fetchAll();
    }

    public function updateStatus($id, $status)
    {
        $stmt = $this->pdo->prepare('UPDATE aulas SET status = :status WHERE id = :id');
        return $stmt->execute(['id' => $id, 'status' => $status]);
    }

    public function delete($id)
    {
        $stmt = $this->pdo->prepare('DELETE FROM aulas WHERE id = :id');
        return $stmt->execute(['id' => $id]);
    }
}