<?php
namespace App\Models;

use PDO;

class ConfigWhatsapp
{
    public $pdo;

    public function __construct()
    {
        require_once(dirname(__DIR__, 2) . '/config/database.php');
        $this->pdo = getPDO();
    }

    public function getConfig()
    {
        $stmt = $this->pdo->query('SELECT * FROM config_whatsapp ORDER BY id DESC LIMIT 1');
        return $stmt->fetch();
    }

    public function create($instancia, $qrcode, $status = 'pendente')
    {
        $stmt = $this->pdo->prepare('
            INSERT INTO config_whatsapp (instancia, qrcode, status) 
            VALUES (:instancia, :qrcode, :status)
        ');
        return $stmt->execute([
            'instancia' => $instancia,
            'qrcode' => $qrcode,
            'status' => $status
        ]);
    }

    public function updateStatus($id, $status)
    {
        $stmt = $this->pdo->prepare('UPDATE config_whatsapp SET status = :status WHERE id = :id');
        return $stmt->execute(['id' => $id, 'status' => $status]);
    }

    public function delete($id)
    {
        $stmt = $this->pdo->prepare('DELETE FROM config_whatsapp WHERE id = :id');
        return $stmt->execute(['id' => $id]);
    }
}