<?php
namespace App\Models;

use PDO;

class Usuario
{
    public $pdo;

    public function __construct()
    {
        require_once(dirname(__DIR__, 2) . '/config/database.php');
        $this->pdo = getPDO();
    }

    public function findByEmail($email)
    {
        $stmt = $this->pdo->prepare('SELECT * FROM usuarios WHERE email = :email');
        $stmt->execute(['email' => $email]);
        return $stmt->fetch();
    }

    public function findById($id)
    {
        $stmt = $this->pdo->prepare('SELECT * FROM usuarios WHERE id = :id');
        $stmt->execute(['id' => $id]);
        return $stmt->fetch();
    }

    public function create($nome, $cpf, $telefone, $email, $senha, $tipo)
    {
        $senhaHash = password_hash($senha, PASSWORD_DEFAULT);
        $stmt = $this->pdo->prepare('
            INSERT INTO usuarios (nome, cpf, telefone, email, senha, tipo) 
            VALUES (:nome, :cpf, :telefone, :email, :senha, :tipo)
        ');
        return $stmt->execute([
            'nome' => $nome,
            'cpf' => $cpf,
            'telefone' => $telefone,
            'email' => $email,
            'senha' => $senhaHash,
            'tipo' => $tipo
        ]);
    }

    public function update($id, $nome, $cpf, $telefone, $email)
    {
        $stmt = $this->pdo->prepare('
            UPDATE usuarios 
            SET nome = :nome, cpf = :cpf, telefone = :telefone, email = :email 
            WHERE id = :id
        ');
        return $stmt->execute([
            'id' => $id,
            'nome' => $nome,
            'cpf' => $cpf,
            'telefone' => $telefone,
            'email' => $email
        ]);
    }

    public function delete($id)
    {
        $stmt = $this->pdo->prepare('DELETE FROM usuarios WHERE id = :id');
        return $stmt->execute(['id' => $id]);
    }

    public function getAll($tipo = null)
    {
        if ($tipo) {
            $stmt = $this->pdo->prepare('SELECT * FROM usuarios WHERE tipo = :tipo');
            $stmt->execute(['tipo' => $tipo]);
        } else {
            $stmt = $this->pdo->query('SELECT * FROM usuarios');
        }
        return $stmt->fetchAll();
    }
}