<?php
function getPDO() {
    $host = $_ENV['DB_HOST'] ?? 'localhost';
    $dbname = $_ENV['DB_NAME'] ?? 'autoescola';
    $username = $_ENV['DB_USER'] ?? 'root';
    $password = $_ENV['DB_PASS'] ?? '';
    
    try {
        $pdo = new PDO("mysql:host={$host};dbname={$dbname};charset=utf8", $username, $password);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
        return $pdo;
    } catch (PDOException $e) {
        die('Erro de conexão com o banco de dados: ' . $e->getMessage());
    }
}

// Função para criar tabelas se não existirem
function createTables() {
    $pdo = getPDO();
    
    // Tabela usuarios
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS usuarios (
            id INT AUTO_INCREMENT PRIMARY KEY,
            nome VARCHAR(255) NOT NULL,
            cpf VARCHAR(14) UNIQUE NOT NULL,
            telefone VARCHAR(20) NOT NULL,
            email VARCHAR(255) UNIQUE NOT NULL,
            senha VARCHAR(255) NOT NULL,
            tipo ENUM('diretor', 'instrutor', 'aluno') NOT NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        )
    ");
    
    // Tabela aulas
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS aulas (
            id INT AUTO_INCREMENT PRIMARY KEY,
            aluno_id INT NOT NULL,
            instrutor_id INT NOT NULL,
            data DATE NOT NULL,
            hora_inicio TIME NOT NULL,
            hora_fim TIME NOT NULL,
            status ENUM('agendada', 'confirmada', 'cancelada', 'concluida') DEFAULT 'agendada',
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (aluno_id) REFERENCES usuarios(id) ON DELETE CASCADE,
            FOREIGN KEY (instrutor_id) REFERENCES usuarios(id) ON DELETE CASCADE
        )
    ");
    
    // Tabela config_whatsapp
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS config_whatsapp (
            id INT AUTO_INCREMENT PRIMARY KEY,
            instancia VARCHAR(255),
            qrcode TEXT,
            status ENUM('pendente', 'conectado', 'desconectado') DEFAULT 'pendente',
            atualizado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        )
    ");
    
    // Criar usuário diretor padrão se não existir
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM usuarios WHERE tipo = 'diretor'");
    $stmt->execute();
    if ($stmt->fetchColumn() == 0) {
        $senhaHash = password_hash('admin123', PASSWORD_DEFAULT);
        $pdo->prepare("
            INSERT INTO usuarios (nome, cpf, telefone, email, senha, tipo) 
            VALUES ('Diretor', '000.000.000-00', '(00) 00000-0000', 'diretor@autoescola.com', ?, 'diretor')
        ")->execute([$senhaHash]);
    }
}

// Criar tabelas ao incluir este arquivo
createTables();