-- Criação do banco de dados (execute uma vez, se necessário)
CREATE DATABASE IF NOT EXISTS autoescola DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE autoescola;

-- Tabela de usuários
CREATE TABLE IF NOT EXISTS usuarios (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nome VARCHAR(100) NOT NULL,
    cpf VARCHAR(14) NOT NULL UNIQUE,
    telefone VARCHAR(20) NOT NULL,
    email VARCHAR(100) NOT NULL UNIQUE,
    senha VARCHAR(255) NOT NULL,
    tipo ENUM('diretor', 'instrutor', 'aluno') NOT NULL,
    criado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Tabela de aulas práticas
CREATE TABLE IF NOT EXISTS aulas (
    id INT AUTO_INCREMENT PRIMARY KEY,
    aluno_id INT NOT NULL,
    instrutor_id INT NOT NULL,
    data DATE NOT NULL,
    hora_inicio TIME NOT NULL,
    hora_fim TIME NOT NULL,
    status ENUM('agendada','concluida','cancelada') DEFAULT 'agendada',
    criado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    atualizado_em TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (aluno_id) REFERENCES usuarios(id),
    FOREIGN KEY (instrutor_id) REFERENCES usuarios(id)
);

-- Tabela para configuração e status da integração WhatsApp Evolution API
CREATE TABLE IF NOT EXISTS config_whatsapp (
    id INT AUTO_INCREMENT PRIMARY KEY,
    instancia VARCHAR(100) NOT NULL,
    qrcode TEXT,
    status ENUM('pendente','conectado','erro') DEFAULT 'pendente',
    atualizado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);