'use strict';

function queryParams(p) {
    return {
        "vencimento": $('#client_status_filter').val(),
        page: p.offset / p.limit + 1,
        limit: p.limit,
        sort: p.sort,
        order: p.order,
        offset: p.offset,
        search: p.search
    };
}

window.icons = {
    refresh: 'bx-refresh'
}

function loadingTemplate(message) {
    return '<i class="bx bx-loader-alt bx-spin bx-flip-vertical"></i>';
}

document.addEventListener('DOMContentLoaded', function () {
    // Carregar servidores e planos via AJAX
    fetch(loadDataUrl)
        .then(response => {
            if (!response.ok) {
                throw new Error('Erro ao carregar servidores e planos');
            }
            return response.json();
        })
        .then(data => {
            const servidores = data.servidores;
            const planos = data.planos;
            const planosRevenda = data.planos_revenda;

            const servidorSelect = document.getElementById('addClientServidor');
            const planoSelect = document.getElementById('addClientPlano');

            // Limpar opções existentes
            servidorSelect.innerHTML = '';
            planoSelect.innerHTML = '';

            // Preencher opções de servidores
            servidores.forEach(servidor => {
                const option = document.createElement('option');
                option.value = servidor.id;
                option.textContent = servidor.nome;
                servidorSelect.appendChild(option);
            });

            // Preencher opções de planos
            planos.forEach(plano => {
                const option = document.createElement('option');
                option.value = plano.id;
                option.textContent = plano.nome;
                planoSelect.appendChild(option);
            });

            // Utilize os planosRevenda conforme necessário
            console.log(planosRevenda);
        })
        .catch(error => console.error('Erro ao carregar servidores e planos:', error));
});

$('#client_status_filter').on('change', function (e) {
    e.preventDefault();
    $('#table').bootstrapTable('refresh', {query: queryParams});
});

function sendLoginDetails(clienteId) {
    if (confirm('Tem certeza que deseja enviar os dados de login para este cliente?')) {
        window.location.href = `/send-login-details/${clienteId}`;
    }
}

function generatePassword(inputId) {
    const length = 12;
    const charset = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()_+~`|}{[]:;?><,./-=";
    let password = "";
    for (let i = 0, n = charset.length; i < length; ++i) {
        password += charset.charAt(Math.floor(Math.random() * n));
    }
    document.getElementById(inputId).value = password;
}

function togglePasswordVisibility(inputId) {
    const input = document.getElementById(inputId);
    const icon = document.getElementById('togglePasswordIcon');
    if (input.type === 'password') {
        input.type = 'text';
        icon.classList.remove('fa-eye');
        icon.classList.add('fa-eye-slash');
    } else {
        input.type = 'password';
        icon.classList.remove('fa-eye-slash');
        icon.classList.add('fa-eye');
    }
}

$(document).ready(function() {
    $('.customerTable').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ],
        initComplete: function() {
            this.api().columns().every(function() {
                var column = this;
                var select = $('<select><option value=""></option></select>')
                    .appendTo($(column.footer()).empty())
                    .on('change', function() {
                        var val = $.fn.dataTable.util.escapeRegex(
                            $(this).val()
                        );

                        column
                            .search(val ? '^' + val + '$' : '', true, false)
                            .draw();
                    });

                column.data().unique().sort().each(function(d, j) {
                    select.append('<option value="' + d + '">' + d + '</option>')
                });
            });
        }
    });
});

// Adicionando a lógica de exclusão diretamente aqui
$(document).on('click', '.delete-selected', function (e) {
    e.preventDefault();
    var $this = $(this);
    var table = $(this).data('table');
    var type = $(this).data('type');
    var destroyUrl = '/app/ecommerce/customer/destroy_multiple';

    var selections = $('#' + table).bootstrapTable('getSelections');
    var selectedIds = selections.map(function (row) {
        return row.id; // Substitua 'id' pelo campo que contém o ID único
    });

    console.log('Selected IDs:', selectedIds);
    console.log('Selections:', selections);

    if (selectedIds.length > 0) {
        $('#confirmDeleteSelectedModal').modal('show');
        $('#confirmDeleteSelectedModal').off('click', '#confirmDeleteSelections');
        $('#confirmDeleteSelectedModal').on('click', '#confirmDeleteSelections', function (e) {
            $('#confirmDeleteSelections').html('Por favor, aguarde...').attr('disabled', true);
            $.ajax({
                url: destroyUrl,
                type: 'DELETE',
                data: JSON.stringify({
                    'ids': selectedIds,
                }),
                contentType: 'application/json',
                headers: {
                    'X-CSRF-TOKEN': $('input[name="_token"]').attr('value') // Substitua pelo seu método de obter o token CSRF
                },
                success: function (response) {
                    $('#confirmDeleteSelections').html('Sim').attr('disabled', false);
                    $('#confirmDeleteSelectedModal').modal('hide');
                    $('#' + table).bootstrapTable('refresh');
                    if (response.error == false) {
                        toastr.success(response.message);
                    } else {
                        toastr.error(response.message);
                    }
                },
                error: function (data) {
                    $('#confirmDeleteSelections').html('Sim').attr('disabled', false);
                    $('#confirmDeleteSelectedModal').modal('hide');
                    toastr.error('Algo deu errado.');
                }
            });
        });
    } else {
        toastr.error('Por favor, selecione registros para excluir.');
    }
});
document.getElementById('copyButton').addEventListener('click', function() {
    navigator.clipboard.writeText(document.getElementById('loginUrl').value).then(function() {
        toastr.success('URL copiada com sucesso!');
    }).catch(function(err) {
        toastr.error('Erro ao copiar a URL.');
        console.error('Erro ao copiar o texto: ', err);
    });
});