'use strict';

function queryParams(p) {
    return {
        page: p.offset / p.limit + 1,
        limit: p.limit,
        sort: p.sort,
        order: p.order,
        offset: p.offset,
        search: p.search,
        filter: $('#filter').val() // Adiciona o filtro aos parâmetros da query
    };
}

window.icons = {
    refresh: 'bx-refresh'
}

function loadingTemplate(message) {
    return '<i class="bx bx-loader-alt bx-spin bx-flip-vertical"></i>';
}

function nameFormatter(value, row, index) {
    return [row.first_name, row.last_name].join(' ');
}

$('#client_status_filter, #client_internal_purpose_filter').on('change', function (e) {
    e.preventDefault();
    $('#table').bootstrapTable('refresh');
});

// Adicionando a lógica de exclusão diretamente aqui
$(document).on('click', '.delete-selected', function (e) {
    e.preventDefault();
    var $this = $(this);
    var table = $(this).data('table');
    var type = $(this).data('type');

    var selections = $('#' + table).bootstrapTable('getSelections');
    var selectedIds = selections.map(function (row) {
        return row.id; // Substitua 'id' pelo campo que contém o ID único
    });

    console.log('Selected IDs:', selectedIds);
    console.log('Selections:', selections);

    if (selectedIds.length > 0) {
        $('#confirmDeleteSelectedModal').modal('show');
        $('#confirmDeleteSelectedModal').off('click', '#confirmDeleteSelections');
        $('#confirmDeleteSelectedModal').on('click', '#confirmDeleteSelections', function (e) {
            $('#confirmDeleteSelections').html('Por favor, aguarde...').attr('disabled', true);
            $.ajax({
                url: destroyMultipleUrl,
                type: 'DELETE',
                data: JSON.stringify({
                    'ids': selectedIds,
                }),
                contentType: 'application/json',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') // Substitua pelo seu método de obter o token CSRF
                },
                success: function (response) {
                    $('#confirmDeleteSelections').html('Sim').attr('disabled', false);
                    $('#confirmDeleteSelectedModal').modal('hide');
                    $('#' + table).bootstrapTable('refresh');
                    if (response.error == false) {
                        toastr.success(response.message);
                    } else {
                        toastr.error(response.message);
                    }
                },
                error: function (data) {
                    $('#confirmDeleteSelections').html('Sim').attr('disabled', false);
                    $('#confirmDeleteSelectedModal').modal('hide');
                    toastr.error('Algo deu errado.');
                }
            });
        });
    } else {
        toastr.error('Por favor, selecione registros para excluir.');
    }
});

// Adicionando a lógica para o filtro
$(document).on('change', '#filter', function (e) {
    e.preventDefault();
    $('#table').bootstrapTable('refresh');
});