'use strict';
$('#status , #filter_by_type').on('change', function () {
    $('#table').bootstrapTable('refresh');
});
function queryParams(p) {
    return {
        page: p.offset / p.limit + 1,
        limit: p.limit,
        sort: p.sort,
        order: p.order,
        offset: p.offset,
        search: p.search,
        status: $('#status').val(),
        type: $('#filter_by_type').val()
    };
}
window.icons = {
    refresh: 'bx-refresh',
    toggleOff: 'bx-toggle-left',
    toggleOn: 'bx-toggle-right'
}
function loadingTemplate(message) {
    return '<i class="bx bx-loader-alt bx-spin bx-flip-vertical" ></i>'
}

function actionFormatter(value, row, index) {
    return [
        '<a href="' + routePrefix + '/plans/edit/' + row.id + '" title=' + label_update + '>' +
        '<i class="bx bx-edit mx-1">' +
        '</i>' +
        '</a>' +
        '<button title=' + label_delete + ' type="button" class="btn delete" data-id=' + row.id + ' data-type="plans">' +
        '<i class="bx bx-trash text-danger mx-1"></i>' +
        '</button>'
    ]
}
$(document).ready(function () {
    $('#createPlanButton').on("click", function (event) {
        event.preventDefault(); // Prevent default form submission
        var $submitBtn = $(this);
        var orignalText = $submitBtn.text();
        $submitBtn.text(label_please_wait).prop('disabled', true);

        // Basic validation
        let isValid = true;
        const planName = $('#planName').val().trim();
        const planDescription = $('#planDescription').val().trim();
        const limiteFaturas = parseInt($('#limiteFaturas').val());
        const limiteClientes = parseInt($('#limiteClientes').val());
        const suportePrioritario = $('#suportePrioritario').val();
        const selectedModules = [];
        const tenureSwitchChecked = $('#allTenuresSwitch').prop('checked');
        const isPlanFree = !tenureSwitchChecked;

        $('.module-checkbox').each(function () {
            if ($(this).is(':checked')) {
                selectedModules.push($(this).val());
            }
        });

        // Check for empty fields
        if (!planName || !planDescription || !suportePrioritario) {
            isValid = false;
            toastr.error('Por favor, preencha todos os campos obrigatórios.');
            $submitBtn.text(orignalText).prop('disabled', false);
        }

        // Verificar entradas não numéricas
        if (isNaN(limiteFaturas) || isNaN(limiteClientes)) {
            isValid = false;
            toastr.error('Os valores máximos devem ser numéricos.');
            $submitBtn.text(orignalText).prop('disabled', false);
        }

        // Verificar valores negativos
        if (limiteFaturas < 0 || limiteClientes < 0) {
            isValid = false;
            toastr.error('Os valores máximos não podem ser negativos.');
            $submitBtn.text(orignalText).prop('disabled', false);
        }

        // Verificar módulos selecionados
        if (selectedModules.length === 0) {
            isValid = false;
            toastr.error('Por favor, selecione pelo menos um módulo.');
            $submitBtn.text(orignalText).prop('disabled', false);
        }

        // Check for tenure pricing if switch is checked and plan is not free
        if (tenureSwitchChecked) {
            let prices = {}; // Object to store main prices by tenure
            // Validate main prices and store them in the prices object
            $('.tenure-price').each(function () {
                const tenure = $(this).attr('id').replace('_price', '');
                const price = $(this).val().trim();
                if (!price) {
                    isValid = false;
                    toastr.error('Por favor, insira o preço para todas as durações.');
                    $submitBtn.text(orignalText).prop('disabled', false);
                    return false; // Sair do loop cedo
                }
                const parsedPrice = parseFloat(price);
                if (isNaN(parsedPrice) || parsedPrice < 0) {
                    isValid = false;
                    toastr.error('O preço deve ser um valor numérico não negativo.');
                    $submitBtn.text(orignalText).prop('disabled', false);
                    return false; // Sair do loop cedo
                }
                prices[tenure] = parsedPrice; // Armazene o preço com sua duração
            });

            // Additional validation for discounted prices
            if ($('.tenure-discounted-price').length > 0) {
                $('.tenure-discounted-price').each(function () {
                    const tenure = $(this).attr('id').replace('_discounted_price', '');
                    const discountedPrice = $(this).val().trim();
                    if (!discountedPrice) {
                        isValid = false;
                        toastr.error('Por favor, insira o preço com desconto para todas as durações.');
                        $submitBtn.text(orignalText).prop('disabled', false);
                        return false; // Sair do loop cedo
                    }
                    const parsedDiscountedPrice = parseFloat(discountedPrice);
                    if (isNaN(parsedDiscountedPrice) || parsedDiscountedPrice < 0) {
                        isValid = false;
                        toastr.error('O preço com desconto deve ser um valor numérico não negativo.');
                        $submitBtn.text(orignalText).prop('disabled', false);
                        return false; // Sair do loop cedo
                    }
                    if (parsedDiscountedPrice >= prices[tenure]) {
                        isValid = false;
                        toastr.error('O preço com desconto deve ser menor que o preço principal.');
                        $submitBtn.text(orignalText).prop('disabled', false);
                        return false; // Sair do loop cedo
                    }
                });
            }
        }

        var status = $('input[name="status"]:checked').val();

        if (isValid) {
            var fileInput = document.getElementById('planImage');
            var file = fileInput.files[0];
            var tenurePrices = getTenurePrices();
            var discountedPrices = getDiscountedPrices();

            var formData = new FormData();
            formData.append('nome', planName);
            formData.append('descricao', planDescription);
            formData.append('limite_faturas', limiteFaturas);
            formData.append('limite_clientes', limiteClientes);
            formData.append('suporte_prioritario', suportePrioritario);
            formData.append('modulos', JSON.stringify(selectedModules));
            formData.append('preco_mensal', tenurePrices.monthly);
            formData.append('preco_mensal_descontado', discountedPrices.monthly);
            formData.append('preco_anual', tenurePrices.yearly);
            formData.append('preco_anual_descontado', discountedPrices.yearly);
            formData.append('preco_vitalicio', tenurePrices.lifetime);
            formData.append('preco_vitalicio_descontado', discountedPrices.lifetime);
            formData.append('tipo_plano', $('#plan_type').val());
            formData.append('status', status);
            formData.append('plan_image', file);

            $.ajax({
                url: $('#plan-create-form').attr('action'),
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('input[name="_token"]').attr('value')
                },
                data: formData,
                contentType: false,
                processData: false,
                success: function (response) {
                    if (!response.error) {
                        toastr.success(response.message);
                        setTimeout(function () {
                            window.location = response.redirect_url;
                        }, 3000);
                    } else {
                        toastr.error(response.message);
                        setTimeout(function () {
                            window.location.reload();
                        }, 3000);
                    }
                },
                error: function (response) {
                    $('#createPlanButton').text(label_create_plan);
                    $('#createPlanButton').prop('disabled', false);
                    if (response.status === 422) {
                        var errors = response.responseJSON.errors;
                        $.each(errors, function (field, messages) {
                            toastr.error(messages.join(', '));
                        });
                    } else {
                        toastr.error('Ocorreu um erro inesperado.');
                    }
                },
                complete: function () {
                    $submitBtn.text(orignalText).prop('disabled', false);
                }
            });
        }
    });

    // Function to get tenure prices
    function getTenurePrices() {
        const tenurePrices = {};
        $('.tenure-price').each(function () {
            const tenure = $(this).attr('id').replace('_price', '');
            tenurePrices[tenure] = $(this).val().trim();
        });
        return tenurePrices;
    }

    // Function to get discounted prices
    function getDiscountedPrices() {
        const discountedPrices = {};
        $('.tenure-discounted-price').each(function () {
            const tenure = $(this).attr('id').replace('_discounted_price', '');
            discountedPrices[tenure] = $(this).val().trim();
        });
        return discountedPrices;
    }

    // Select all checkboxes
    $('#select-all-checkbox').change(function () {
        $('.module-checkbox').prop('checked', $(this).prop('checked'));
    });

    $('.module-checkbox').change(function () {
        if (!$(this).prop('checked')) {
            $('#select-all-checkbox').prop('checked', false);
        }
    });

    function updateSelectAllCheckbox() {
        const allChecked = $('.module-checkbox').length === $('.module-checkbox:checked').length;
        $('#select-all-checkbox').prop('checked', allChecked);
    }

    // Initial check when the page loads
    updateSelectAllCheckbox();

    $('.module-checkbox').on('change', function () {
        updateSelectAllCheckbox();
    });

    // Hide pricing fields if switch is unchecked by default
    if (!$('#allTenuresSwitch').prop('checked')) {
        $('#plan_type').val('free');
        $('.monthly_tenure , .yearly_tenure , .lifetime_tenure').hide();
    }

    // Toggle visibility of pricing fields when switch is toggled
    $('#allTenuresSwitch').change(function () {
        if ($(this).prop('checked')) {
            $('#plan_type').val('paid');
            $('.monthly_tenure , .yearly_tenure , .lifetime_tenure').show();
        } else {
            $('#plan_type').val('free');
            $('.monthly_tenure , .yearly_tenure , .lifetime_tenure').hide();
        }
    });
});