'use strict';
function queryParams(p) {
    return {
        "status": $('#user_status_filter').val(),
        "role_ids": $('#user_roles_filter').val(),
        page: p.offset / p.limit + 1,
        limit: p.limit,
        sort: p.sort,
        order: p.order,
        offset: p.offset,
        search: p.search
    };
}

window.icons = {
    refresh: 'bx-refresh',
    toggleOff: 'bx-toggle-left',
    toggleOn: 'bx-toggle-right'
}

function loadingTemplate(message) {
    return '<i class="bx bx-loader-alt bx-spin bx-flip-vertical" ></i>'
}

$('#user_status_filter, #user_roles_filter').on('change', function (e) {
    e.preventDefault();
    $('#table').bootstrapTable('refresh');
});

$(document).ready(function () {
    $('#user_status_filter').select2();
});

$(document).on('click', '.delete-selected', function (e) {
    e.preventDefault();
    var $this = $(this);
    var table = $(this).data('table');
    var type = $(this).data('type');

    var selections = $('#' + table).bootstrapTable('getSelections');
    var selectedIds = selections.map(function (row) {
        return row.id; // Substitua 'id' pelo campo que contém o ID único
    });

    console.log('Selected IDs:', selectedIds);
    console.log('Selections:', selections);

    if (selectedIds.length > 0) {
        $('#confirmDeleteSelectedModal').modal('show');
        $('#confirmDeleteSelectedModal').off('click', '#confirmDeleteSelections');
        $('#confirmDeleteSelectedModal').on('click', '#confirmDeleteSelections', function (e) {
            $('#confirmDeleteSelections').html('Por favor, aguarde...').attr('disabled', true);
            $.ajax({
                url: destroyMultipleUrl,
                type: 'DELETE', // Alterado para 'DELETE'
                data: JSON.stringify({
                    'user_ids': selectedIds, // Alterado para 'user_ids'
                }),
                contentType: 'application/json',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') // Certifique-se de que o token CSRF está correto
                },
                success: function (response) {
                    $('#confirmDeleteSelections').html('Sim').attr('disabled', false);
                    $('#confirmDeleteSelectedModal').modal('hide');
                    $('#' + table).bootstrapTable('refresh');
                    if (response.error == false) {
                        toastr.success(response.message);
                    } else {
                        toastr.error(response.message);
                    }
                },
                error: function (data) {
                    $('#confirmDeleteSelections').html('Sim').attr('disabled', false);
                    $('#confirmDeleteSelectedModal').modal('hide');
                    toastr.error('Algo deu errado.');
                }
            });
        });
    } else {
        toastr.error('Por favor, selecione registros para excluir.');
    }
});