<?php
namespace App\Controllers;

use App\Models\Usuario;

class AlunoController
{
    public function dashboard()
    {
        session_start();
        if (!isset($_SESSION['usuario_id']) || $_SESSION['usuario_tipo'] !== 'aluno') {
            header('Location: /auth/login');
            exit;
        }

        $aluno_id = $_SESSION['usuario_id'];

        // Busca aulas agendadas para o aluno logado
        require_once(dirname(__DIR__, 2) . '/config/database.php');
        $pdo = getPDO();
        $stmt = $pdo->prepare('
            SELECT a.id, a.data, a.hora_inicio, a.hora_fim, a.status, u.nome as instrutor_nome
            FROM aulas a
            JOIN usuarios u ON a.instrutor_id = u.id
            WHERE a.aluno_id = :aluno_id
            ORDER BY a.data DESC, a.hora_inicio DESC
        ');
        $stmt->execute(['aluno_id' => $aluno_id]);
        $aulas = $stmt->fetchAll();

        echo "<h2>Painel do Aluno</h2>";
        echo "<h4>Suas aulas agendadas:</h4>";
        if ($aulas) {
            echo "<table border='1' cellpadding='6'><tr>
                    <th>Data</th><th>Início</th><th>Fim</th><th>Instrutor</th><th>Status</th>
                  </tr>";
            foreach ($aulas as $aula) {
                echo "<tr>
                        <td>{$aula['data']}</td>
                        <td>{$aula['hora_inicio']}</td>
                        <td>{$aula['hora_fim']}</td>
                        <td>{$aula['instrutor_nome']}</td>
                        <td>{$aula['status']}</td>
                        <td>
                            <form method='post' action='/aluno/confirmar-presenca'>
                                <input type='hidden' name='aula_id' value='{$aula['id']}'>
                                <button type='submit'>Confirmar Presença</button>
                            </form>
                        </td>
                      </tr>";
            }
            echo "</table>";
        } else {
            echo "<p>Você ainda não possui aulas agendadas.</p>";
        }
        echo "<a href='/auth/logout'>Sair</a>";
    }

    // Método para confirmação de presença será implementado futuramente

    // Confirmar presença em uma aula
    public function confirmarPresenca($aula_id)
    {
        session_start();
        if (!isset($_SESSION['usuario_id']) || $_SESSION['usuario_tipo'] !== 'aluno') {
            header('Location: /auth/login');
            exit;
        }
        require_once(dirname(__DIR__, 2) . '/config/database.php');
        $pdo = getPDO();

        // Verifica se a aula pertence ao aluno logado
        $stmt = $pdo->prepare('SELECT * FROM aulas WHERE id = :id AND aluno_id = :aluno_id');
        $stmt->execute(['id' => $aula_id, 'aluno_id' => $_SESSION['usuario_id']]);
        $aula = $stmt->fetch();
        if (!$aula) {
            echo "<p>Aula não encontrada.</p><a href='/aluno/dashboard'>Voltar</a>";
            exit;
        }

        // Atualiza status para "concluida"
        $stmt = $pdo->prepare('UPDATE aulas SET status = "concluida" WHERE id = :id');
        $stmt->execute(['id' => $aula_id]);
        echo "<p>Presença confirmada com sucesso!</p><a href='/aluno/dashboard'>Voltar</a>";
    }
}