<?php
namespace App\Controllers;

use App\Models\Usuario;
use App\Models\Aula;

class InstrutorController
{
    public function dashboard()
    {
        session_start();
        if (!isset($_SESSION['usuario_id']) || $_SESSION['usuario_tipo'] !== 'instrutor') {
            header('Location: /auth/login');
            exit;
        }

        $usuario_nome = $_SESSION['usuario_nome'];

        echo "<h2>Painel do Instrutor</h2>";
        echo "<p>Bem-vindo, {$usuario_nome}!</p>";
        echo "<a href='/instrutor/alunos'>Listar Alunos</a> | ";
        echo "<a href='/instrutor/aulas'>Minhas Aulas</a> | ";
        echo "<a href='/auth/logout'>Sair</a>";
    }

    // Listar alunos
    public function alunos()
    {
        session_start();
        if (!isset($_SESSION['usuario_id']) || $_SESSION['usuario_tipo'] !== 'instrutor') {
            header('Location: /auth/login');
            exit;
        }

        $usuarioModel = new Usuario();
        $pdo = (new Usuario())->pdo;

        $stmt = $pdo->query("SELECT * FROM usuarios WHERE tipo = 'aluno'");
        $alunos = $stmt->fetchAll();

        echo "<h2>Lista de Alunos</h2>";
        if ($alunos) {
            echo "<table border='1' cellpadding='6'><tr>
                    <th>Nome</th><th>CPF</th><th>Telefone</th><th>Email</th><th>Ações</th>
                  </tr>";
            foreach ($alunos as $aluno) {
                echo "<tr>
                        <td>{$aluno['nome']}</td>
                        <td>{$aluno['cpf']}</td>
                        <td>{$aluno['telefone']}</td>
                        <td>{$aluno['email']}</td>
                        <td>
                            <a href='/instrutor/agendarAula/{$aluno['id']}'>Agendar Aula</a> | 
                            <a href='/instrutor/historico/{$aluno['id']}'>Histórico</a>
                        </td>
                      </tr>";
            }
            echo "</table>";
        } else {
            echo "<p>Nenhum aluno cadastrado.</p>";
        }
        echo "<br><a href='/instrutor/dashboard'>Voltar</a>";
    }

    // Formulário de agendamento de aula
    public function agendarAula($aluno_id)
    {
        session_start();
        if (!isset($_SESSION['usuario_id']) || $_SESSION['usuario_tipo'] !== 'instrutor') {
            header('Location: /auth/login');
            exit;
        }
        echo "<h2>Agendar Aula para Aluno</h2>
            <form method='post' action='/instrutor/salvarAula/{$aluno_id}'>
                <label>Data:</label> <input type='date' name='data' required><br>
                <label>Hora de início:</label> <input type='time' name='hora_inicio' required><br>
                <label>Duração (minutos):</label> <input type='number' name='duracao' min='10' max='300' required><br>
                <button type='submit'>Agendar</button>
            </form>
            <a href='/instrutor/alunos'>Voltar</a>";
    }

    // Salvar agendamento de aula
    public function salvarAula($aluno_id)
    {
        session_start();
        if (!isset($_SESSION['usuario_id']) || $_SESSION['usuario_tipo'] !== 'instrutor') {
            header('Location: /auth/login');
            exit;
        }
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = $_POST['data'];
            $hora_inicio = $_POST['hora_inicio'];
            $duracao = max(10, (int)$_POST['duracao']);
            // Calcula hora_fim
            $hora_fim = date('H:i', strtotime("$hora_inicio +{$duracao} minutes"));

            $aulaModel = new Aula();
            $aulaModel->create([
                'aluno_id' => $aluno_id,
                'instrutor_id' => $_SESSION['usuario_id'],
                'data' => $data,
                'hora_inicio' => $hora_inicio,
                'hora_fim' => $hora_fim,
                'status' => 'agendada'
            ]);
            header('Location: /instrutor/aulas');
            exit;
        }
    }

    // Listar aulas do instrutor
    public function aulas()
    {
        session_start();
        if (!isset($_SESSION['usuario_id']) || $_SESSION['usuario_tipo'] !== 'instrutor') {
            header('Location: /auth/login');
            exit;
        }
        $aulaModel = new Aula();
        $aulas = $aulaModel->listByInstrutor($_SESSION['usuario_id']);
        echo "<h2>Minhas Aulas Agendadas</h2>";
        echo "<table border='1' cellpadding='6'><tr><th>Data</th><th>Início</th><th>Fim</th><th>Aluno</th><th>Status</th><th>Ações</th></tr>";
        foreach ($aulas as $aula) {
            echo "<tr>
                <td>{$aula['data']}</td>
                <td>{$aula['hora_inicio']}</td>
                <td>{$aula['hora_fim']}</td>
                <td>{$aula['aluno_nome']}</td>
                <td>{$aula['status']}</td>
                <td>
                    <a href='/instrutor/editarAula/{$aula['id']}'>Editar</a> | 
                    <a href='/instrutor/cancelarAula/{$aula['id']}'>Cancelar</a>
                </td>
              </tr>";
        }
        echo "</table>";
        echo "<br><a href='/instrutor/dashboard'>Voltar</a>";
    }

    // Editar aula (formulário)
    public function editarAula($aula_id)
    {
        session_start();
        if (!isset($_SESSION['usuario_id']) || $_SESSION['usuario_tipo'] !== 'instrutor') {
            header('Location: /auth/login');
            exit;