<?php
namespace Core;

class Router
{
    protected string $controller = 'HomeController';
    protected string $method = 'index';
    protected array $params = [];

    public function __construct()
    {
        // Adiciona namespace dos controllers
        $this->controllerNamespace = 'App\\Controllers\\';
    }

    public function dispatch(string $uri)
    {
        $uri = $this->filterUri($uri);

        if ($uri) {
            $segments = explode('/', $uri);

            // Define controller
            $controllerName = ucfirst(array_shift($segments)) . 'Controller';
            $controllerClass = $this->controllerNamespace . $controllerName;
            if (class_exists($controllerClass)) {
                $this->controller = $controllerName;
            }

            // Define método
            if (isset($segments[0]) && !empty($segments[0])) {
                $this->method = $segments[0];
                array_shift($segments);
            }

            // Parâmetros (agora aceita múltiplos parâmetros)
            $this->params = $segments;
        }

        $controllerClass = $this->controllerNamespace . $this->controller;

        if (!class_exists($controllerClass)) {
            http_response_code(404);
            echo "Controller não encontrado.";
            exit;
        }

        $controllerInstance = new $controllerClass();

        if (!method_exists($controllerInstance, $this->method)) {
            http_response_code(404);
            echo "Método não encontrado.";
            exit;
        }

        // Chama o método com todos os parâmetros extras (ex: /admin/editarInstrutor/5)
        call_user_func_array([$controllerInstance, $this->method], $this->params);
    }

    protected function filterUri($uri)
    {
        // Remove query string e barra inicial
        $uri = parse_url($uri, PHP_URL_PATH);
        $uri = trim($uri, '/');
        return $uri;
    }
}