<?php
require_once '../vendor/autoload.php';
require_once '../config/database.php';

// Carregar variáveis de ambiente
if (file_exists('../.env')) {
    $dotenv = Dotenv\Dotenv::createImmutable('../');
    $dotenv->load();
}

// Roteamento simples
$request = $_SERVER['REQUEST_URI'];
$path = parse_url($request, PHP_URL_PATH);
$segments = explode('/', trim($path, '/'));

// Remoção de parâmetros GET da URL
$path = strtok($path, '?');

switch ($path) {
    case '/':
        $controller = new App\Controllers\HomeController();
        $controller->index();
        break;
    case '/auth/login':
        $controller = new App\Controllers\AuthController();
        $controller->login();
        break;
    case '/auth/doLogin':
        $controller = new App\Controllers\AuthController();
        $controller->doLogin();
        break;
    case '/auth/logout':
        $controller = new App\Controllers\AuthController();
        $controller->logout();
        break;
    case '/admin/dashboard':
        $controller = new App\Controllers\AdminController();
        $controller->dashboard();
        break;
    case '/admin/instrutores':
        $controller = new App\Controllers\AdminController();
        $controller->instrutores();
        break;
    case '/admin/alunos':
        $controller = new App\Controllers\AdminController();
        $controller->alunos();
        break;
    case '/instrutor/dashboard':
        $controller = new App\Controllers\InstrutorController();
        $controller->dashboard();
        break;
    case '/instrutor/alunos':
        $controller = new App\Controllers\InstrutorController();
        $controller->alunos();
        break;
    case '/aluno/dashboard':
        $controller = new App\Controllers\AlunoController();
        $controller->dashboard();
        break;
    case '/whatsapp/config':
        $controller = new App\Controllers\WhatsappController();
        $controller->config();
        break;
    case '/whatsapp/gerarInstancia':
        $controller = new App\Controllers\WhatsappController();
        $controller->gerarInstancia();
        break;
    default:
        // Roteamento dinâmico para parâmetros
        if (count($segments) >= 3) {
            $controllerName = ucfirst($segments[0]);
            $method = $segments[1];
            $param = $segments[2];
            
            $controllerClass = "App\\Controllers\\{$controllerName}Controller";
            if (class_exists($controllerClass)) {
                $controller = new $controllerClass();
                if (method_exists($controller, $method)) {
                    $controller->$method($param);
                    break;
                }
            }
        }
        http_response_code(404);
        echo '<h1>404 - Página não encontrada</h1>';
        break;
}