'use strict';

function getUrlParameter(name) {
    name = name.replace(/[\[]/, '\\[').replace(/[\]]/, '\\]');
    var regex = new RegExp('[\\?&]' + name + '=([^&#]*)');
    var results = regex.exec(location.search);
    return results === null ? '' : decodeURIComponent(results[1].replace(/\+/g, ' '));
}

function queryParams(p) {
    return {
        page: p.offset / p.limit + 1,
        limit: p.limit,
        sort: p.sort,
        order: p.order,
        offset: p.offset,
        search: p.search,
        order_id: getUrlParameter('order_id'), // Adiciona o parâmetro order_id se estiver presente na URL
        cliente_nome: getUrlParameter('cliente_nome'), // Adiciona o parâmetro cliente_nome se estiver presente na URL
        transacao_id: getUrlParameter('transacao_id'), // Adiciona o parâmetro transacao_id se estiver presente na URL
        status: getUrlParameter('status') // Adiciona o parâmetro status se estiver presente na URL
    };
}

window.icons = {
    refresh: 'bx-refresh'
}

function loadingTemplate(message) {
    return '<i class="bx bx-loader-alt bx-spin bx-flip-vertical"></i>';
}

function nameFormatter(value, row, index) {
    return [row.first_name, row.last_name].join(' ');
}

$('#client_status_filter, #client_internal_purpose_filter').on('change', function (e) {
    e.preventDefault();
    $('#table').bootstrapTable('refresh');
});

// Adicionando a lógica de exclusão diretamente aqui
$(document).on('click', '.delete-selected', function (e) {
    e.preventDefault();
    var $this = $(this);
    var table = $(this).data('table');
    var type = $(this).data('type');

    var selections = $('#' + table).bootstrapTable('getSelections');
    var selectedIds = selections.map(function (row) {
        return row.id; // Substitua 'id' pelo campo que contém o ID único
    });

    console.log('Selected IDs:', selectedIds);
    console.log('Selections:', selections);

    if (selectedIds.length > 0) {
        $('#confirmDeleteSelectedModal').modal('show');
        $('#confirmDeleteSelectedModal').off('click', '#confirmDeleteSelections');
        $('#confirmDeleteSelectedModal').on('click', '#confirmDeleteSelections', function (e) {
            $('#confirmDeleteSelections').html('Por favor, aguarde...').attr('disabled', true);
            $.ajax({
                url: destroyMultipleUrl,
                type: 'DELETE',
                data: JSON.stringify({
                    'order_ids': selectedIds, // Alterado para 'order_ids'
                }),
                contentType: 'application/json',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') // Certifique-se de que o token CSRF está correto
                },
                success: function (response) {
                    $('#confirmDeleteSelections').html('Sim').attr('disabled', false);
                    $('#confirmDeleteSelectedModal').modal('hide');
                    $('#' + table).bootstrapTable('refresh');
                    if (response.error == false) {
                        toastr.success(response.message);
                    } else {
                        toastr.error(response.message);
                    }
                },
                error: function (data) {
                    $('#confirmDeleteSelections').html('Sim').attr('disabled', false);
                    $('#confirmDeleteSelectedModal').modal('hide');
                    toastr.error('Algo deu errado.');
                }
            });
        });
    } else {
        toastr.error('Por favor, selecione registros para excluir.');
    }
});