function queryParams(p) {
    return {
        page: p.offset / p.limit + 1,
        limit: p.limit,
        sort: p.sort,
        order: p.order,
        offset: p.offset,
        search: p.search
    };
}

function SubscriptionHistory(p) {
    return {
        page: p.offset / p.limit + 1,
        limit: p.limit,
        sort: p.sort,
        order: p.order,
        offset: p.offset,
        search: p.search
    };
}

$(document).ready(function () {
    $('a[data-toggle="content"]').on('click', function (e) {
        e.preventDefault();

        var target = $(this).attr('href');
        $('.content').removeClass('active');
        $(target).addClass('active');
    });

    $('input[name="priceToggle"]').change(function () {
        var selectedTenure = $(this).attr('id');
        console.log('selectedTenure:', selectedTenure); // Adicione esta linha para depuração
        $('.monthly-price, .yearly-price, .lifetime-price').addClass('d-none');
        $('.' + selectedTenure + '-price').removeClass('d-none');
    });

    $('.checkout_btn').on('click', function () {
        var plan_id = $(this).data('planid'); // Use $(this) to reference the clicked button
        var tenure = $('input[name=priceToggle]:checked').attr('id');
        console.log('plan_id:', plan_id); // Adicione esta linha para depuração
        console.log('tenure:', tenure); // Adicione esta linha para depuração

        window.location = 'checkout/' + plan_id + '/' + tenure;
    });

    // Get the total price
    var totalPrice = parseFloat($('input[name="total_price"]').val());
    var planName = $('input[name="plan_name"]').val();
    var planId = $('input[name="plan_id"]').val();
    var tenure = $('input[name="tenure"]').val();
    var currencySymbol = $('input[name="currency_symbol"]').val();
    if (totalPrice === 0) {
        // Show the order summary and proceed button
        $('#paymentMethod').text('Payment Method: Free Plan ');
        $('#finalPlan').text('Plan Name: ' + planName);
        $('#finalPrice').text('Total Price: ' + currencySymbol + totalPrice);
        $('#orderSummaryDiv').addClass('bg-label-primary');
        $('#proceedPaymentBtn').removeClass('d-none');
        $('#changePlanBtn').removeClass('d-none');
    }

    // Add event listener to payment method radio buttons
    $('input[name="options"]').change(function () {
        // Get the selected payment method
        var paymentMethod = $('input[name="options"]:checked').val();
        var formattedPaymentMethod = paymentMethod
            .split('_')                      // Split the string by underscores
            .map(word => word.charAt(0).toUpperCase() + word.slice(1)) // Capitalize each word
            .join(' ');
        var planName = $('input[name="plan_name"]').val();
        var planId = $('input[name="plan_id"]').val();
        var tenure = $('input[name="tenure"]').val();
        var currencySymbol = $('input[name="currency_symbol"]').val();
        var totalPrice = $('input[name="total_price"]').val();

        // Update the order summary dynamically
        $('#paymentMethod').text('Payment Method: ' + formattedPaymentMethod);
        $('#finalPlan').text('Plan Name: ' + planName);
        $('#finalPrice').text('Total Price: ' + currencySymbol + totalPrice);
        $('#orderSummaryDiv').addClass('bg-label-primary');
        $('#proceedPaymentBtn').removeClass('d-none');
        $('#changePlanBtn').removeClass('d-none');

        switch (paymentMethod) {
            case "mercado_pago":
                $('#stripe_checkout').hide();
                break;
            case "bank_transfer":
                $('#stripe_checkout').hide();
                break;
        }
    });

                   $('#paymentIntializeBtn').on("click", function () {
                // Get necessary data
                var finalPrice = parseFloat($('input[name="total_price"]').val());
                var paymentMethod = '';
                if (finalPrice > 0) {
                    paymentMethod = $('input[name="options"]:checked').val();
                } else {
                    paymentMethod = 'free_plan'; // Set payment method to 'free_plan' if price is 0
                }
            
                var planId = $('input[name="plan_id"]').val();
                var tenure = $('input[name="tenure"]').val();
                var user_id = $('input[name="user_id"]').val();
                var currency_symbol = $('input[name="currency_symbol"]').val();
                var url = $(this).data('url');
            
                // Ajax request
                $.ajax({
                    url: url,
                    type: 'post',
                    headers: {
                        'X-CSRF-TOKEN': $('input[name="_token"]').attr('value')
                    },
                    data: {
                        payment_method: paymentMethod,
                        plan_id: planId,
                        tenure: tenure,
                        user_id: user_id,
                        currency_symbol: currency_symbol
                    },
                    success: function (response) {
                        // Handle success response
                        if (response) {
                            if (response.payment_method === 'free_plan') {
                                toastr.success(response.message);
                                var redirectUrl = response.redirect_url;
                                setTimeout(function () {
                                    window.location.href = redirectUrl;
                                }, 2000);
                            }
                            if (response.payment_method === 'bank_transfer') {
                                console.log(response);
                                handleBankTransfer(response);
                            }
                            if (response.payment_method === 'mercado_pago') {
                                console.log(response);
                                handleMercadoPago(response);
                            }
                        } else {
                            toastr.error('Resposta vazia recebida.');
                        }
                    },
                    error: function (xhr, status, error) {
                        // Handle error response
                        var errors = xhr.responseJSON.errors;
                        if (errors) {
                            $.each(errors, function (key, value) {
                                toastr.error(value);
                            });
                        } else {
                            if (xhr.responseJSON.error) {
                                console.log(xhr.responseJSON.error);
                                toastr.error(xhr.responseJSON.error);
                            } else {
                                toastr.error('Ocorreu um erro. Por favor, tente novamente.');
                            }
                        }
                    }
                });
            });
    $('#uploadDocumentModal').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget); // Button that triggered the modal
        var subscriptionId = button.data('subscription-id'); // Extract info from data-* attributes

        var modal = $(this); // Get the modal
        modal.find('#subscription_id').val(subscriptionId); // Set the subscription ID in the hidden input field
    });
});

function handleBankTransfer(response) {
    const bank_details = response.bank_transfer_settings ? JSON.parse(response.bank_transfer_settings) : null;
    const amount = response.finalPrice;
    const currency = response.currency;
    const transaction_id = response.transaction_id;

    if (!bank_details) {
        toastr.error('Detalhes da transferência bancária não encontrados.');
        return;
    }

    console.log(bank_details);

    // Create modal for displaying bank details
    const modalHtml = `
        <div class="modal fade" id="bankTransferModal" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Detalhes da Transferência Bancária</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="alert alert-info">
                            Por favor, transfira ${currency}${amount} usando os seguintes detalhes bancários:
                        </div>
                        <div class="alert alert-primary">
                            ${bank_details.extra_notes}
                        </div>

                        <div class="bank-details">
                            <p><strong>Nome do Banco:</strong> ${bank_details.bank_name}</p>
                            <p><strong>Código do Banco:</strong> ${bank_details.bank_code}</p>
                            <p><strong>Nome da Conta:</strong> ${bank_details.account_name}</p>
                            <p><strong>Número da Conta:</strong> ${bank_details.account_number}</p>
                            <p><strong>Código SWIFT:</strong> ${bank_details.swift_code}</p>

                            <p><strong>Referência da Transação:</strong> ${transaction_id}</p>
                        </div>

                        <div class="alert alert-warning mt-3">
                            Importante: Por favor, inclua o número de referência da transação nos detalhes da sua transferência.
                            Sua assinatura será ativada assim que o pagamento for verificado.
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
                        <button type="button" class="btn btn-primary" onclick="copyBankDetails()">Copiar Detalhes</button>
                    </div>
                </div>
            </div>
        </div>`;

    // Append modal to body if it doesn't exist
    if (!document.getElementById('bankTransferModal')) {
        $('body').append(modalHtml);
    }

    // Show the modal
    $('#bankTransferModal').modal('show');

    // Store transaction details in localStorage for reference
    localStorage.setItem('bankTransfer_' + transaction_id, JSON.stringify({
        amount,
        currency,
        transaction_id,
        timestamp: new Date().toISOString()
    }));
    window.copyBankDetails = function () {
        const bankDetails = document.querySelector('.bank-details').innerText;
        navigator.clipboard.writeText(bankDetails).then(() => {
            toastr.success('Detalhes bancários copiados para a área de transferência');
        }).catch(() => {
            toastr.error('Falha ao copiar os detalhes bancários');
        });
    }
    toastr.success('Por favor, complete a transferência bancária usando os detalhes fornecidos');
}

function handleMercadoPago(response) {
    console.log(response); // Adicione esta linha para depuração

    // Verifique se a resposta contém os dados esperados
    if (response.qr_code_base64 && response.qr_code) {
        const qrCodeBase64 = response.qr_code_base64;
        const qrCode = response.qr_code;
        const qrCodeHtml = `
            <div class="modal fade" id="mercadoPagoModal" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">QR Code para Pagamento</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <div class="alert alert-info text-center">
                                Por favor, escaneie o QR code abaixo para realizar o pagamento:
                            </div>
                            <div class="d-flex justify-content-center mb-3">
                                <img src="data:image/png;base64,${qrCodeBase64}" alt="QR Code" style="width: 250px; height: 250px;">
                            </div>
                            <div class="text-center mb-3">
                                <textarea id="qrCodeText" class="form-control" readonly>${qrCode}</textarea>
                                <button class="btn btn-primary mt-2" id="copyQrCodeButton">Copiar Código QR</button>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
                        </div>
                    </div>
                </div>
            </div>`;

        // Append modal to body if it doesn't exist
        if (!document.getElementById('mercadoPagoModal')) {
            $('body').append(qrCodeHtml);
        }

        // Show the modal
        $('#mercadoPagoModal').modal('show');

        // Add event listener to copy button
        document.getElementById('copyQrCodeButton').addEventListener('click', function() {
            navigator.clipboard.writeText(qrCode).then(() => {
                toastr.success('Código QR copiado para a área de transferência');
            }).catch(() => {
                toastr.error('Falha ao copiar o código QR');
            });
        });
    } else {
        toastr.error('QR code não encontrado na resposta.');
    }
}